%    This library is free software; you can redistribute it and/or
%    modify it under the terms of the GNU Lesser General Public
%    License as published by the Free Software Foundation; either
%    version 2.1 of the License, or (at your option) any later version.

%    This library is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    Lesser General Public License for more details.

%    You should have received a copy of the GNU Lesser General Public License 
%    (lgpl_license.txt) along with this library; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


close all;

myslice = zeros(217,181,37); %for both: 152, for ventricles: 37
index = 1;

  %for i=10:1:161 % for brain
for i=69:1:105 % for ventricles only
    filename = ['slice_', num2str(i), '_seg.png'];
    X = imread(filename);
    myslice(:,:,index) = X;
    index = index + 1;
end

[f, v] = isosurface(myslice,0);
%%% isosurface mesh surface get
p = patch('Faces', f, 'Vertices', v, 'facecolor', 'r');
axis equal;  view(3); 
rotate3d on


%%% marching cube surface get
[m,n,p] = size(myslice);
[X,Y,Z] = meshgrid(1:n,1:m,1:p); 
[F,V] = MarchingCubes(X,Y,Z,myslice, 0);


fid = fopen('hydrocephalus.poly', 'w');
face = size(F,1);
vertice = size(V,1);

fprintf(fid, '%d\t%d\t%d\t%d\n', vertice, 3, 0, 0);

index = 1;
for i=1:vertice
    fprintf(fid, '%d\t%f\t%f\t%f\n',  index, V(index,1), V(index,2), V(index,3));
    index = index + 1;
end
fprintf(fid, '\n');

fprintf(fid, '%d\t%d\n', face, 0);

index = 1;
for i=1:face
    fprintf(fid, '%d\t%d\t%d\n', 1, 0, 0);
    fprintf(fid, '%d\t%d\t%d\t%d\n', 3, F(index,1), F(index,2), F(index,3));
    index = index + 1;
end
fprintf(fid, '\n');

fprintf(fid, '%d\n', 1);
fprintf(fid, '%d\t%d\t%d\t%d\n', 1, 100, 120, 22);
fclose(fid);

% %%% for expanding the volume, turn on the below lines
% grad_V = -gradient(V);
% %quiver3(V(:,1), V(:,2), V(:,3), grad_V(:,1), grad_V(:,2), grad_V(:,3));
% % new_V = V + 10*grad_V/norm(grad_V);
% tmp = [100 120 25]; 
% tmp_V = repmat(tmp,size(V,1),1); 
% tmp_V = V - tmp_V;
% 
% new_V = V + 0.3*tmp_V;
% % 
% p = patch('Faces', F, 'Vertices', new_V, 'facecolor', 'b');
% axis equal;  view(3); 
% rotate3d on
